<?php

if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("member_do_register_end", "A2detector_run");


function A2detector_info()
{
	return array(
		"name"			=> "هاك الكشف عن العضويات المكررة",
		"description"	=> "يقوم بالكشف  عن اي عضو يقوم بالتسجيل اكثر من مرة بنفس الايبي",
		"website"		=> "http://www.mybb-es.com",
		"author"		=> "Edson Ordaz",
		"authorsite"	=> "mailto:nicedo_eeos@hotmail.com",
		"version"		=> "1.1",
		"compatibility"   => "16*",
		"guid"			=> "14b83bd42b5afd3cfbb6b36685a8020c",
		
		//Information - Edson Ordaz
		"codenamegroup"	  => "هاك الكشف عن العضويات المكررة",
		"codename"		=> "aedetector"
	);
}

function A2detector_activate()
{
	global $db, $cache;
	$info = A2detector_info();

	$setting_group = array(
		'name' => $info['codename'],
		'title' => $info['codenamegroup'],
		'description' => "يقوم بالكشف عن عمليات التسجيل باكثر من ايبي.",
		'disporder' => 1,
		'isdefault' => 0,
		);
	$db->insert_query('settinggroups', $setting_group);
	$group = $db->insert_id();
	
	$settings = array(
		$info['codename'].'_subject' => array('عنوان الرسالة', 'ادخل هنا عنوان الرسالة التي سوف تصلك في حالة اكتشاف عمليات تسجيل مكررة', 'textarea', 'Double counting has been detected'),
		$info['codename'].'_body' => array('محتوي الرسالة', 'ادخل هنا محتوي الرسالة<br /><b><font color=red>{numip}</font></b> لكي يظهر عدد التسجيلات التي قام بها من نفس الايبي.<br /><b><font color=red>{ip}</font></b> ليظهر الايبي.<br /><b><font color=red>{names}</font></b> ليظهر اسم العضو.', 'textarea', 'هذه رسالة تلقائية {bbname} لكي تخبرك بان.

------------------------------------------------
لديه عدد {numip} عن طريق الايبي {ip} واسم العضو هو ::
{names}.

------------------------------------------------'),
		$info['codename'].'_sender' => array('اسم العضو المرسل', 'ادخل رقم العضو الذي سيظهر في اسم المرسل', 'text', '1'),
		$info['codename'].'_recipient' => array('العضو المستلم', 'ادخل رقم العضو الذي سوف يستلم الرسالة الخاصه بالتبليغ وتستطيع وضع اكثر من رقم بوضع فاصلة بينهم', 'text', '1'),
	);

	$i = 1;
	foreach($settings as $name => $sinfo)
	{
		$insert_array = array(
			'name' => $name,
			'title' => $db->escape_string($sinfo[0]),
			'description' => $db->escape_string($sinfo[1]),
			'optionscode' => $db->escape_string($sinfo[2]),
			'value' => $db->escape_string($sinfo[3]),
			'gid' => $group,
			'disporder' => $i,
			'isdefault' => 0,
			);
		$db->insert_query('settings', $insert_array);
		$i++;
	}
	rebuild_settings();
	$cache->update('a2detector_errors', 0);
}


function A2detector_deactivate()
{
	global $db;
	$info = A2detector_info();
	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='{$info['codename']}'");
	$db->delete_query("settings","name LIKE '{$info['codename']}_%'");
	$db->delete_query("datacache", "title='a2detector_errors'");
}

function A2detector_run()
{
	global $mybb, $session, $db;
	
	$query_rows = $db->query("SELECT * FROM ".TABLE_PREFIX."users WHERE regip='{$session->ipaddress}'");
    $counts_ips = $db->num_rows($query_rows);
	if($counts_ips > 1)
	{
		$names = array();
		$query = $db->simple_select("users", "*", "regip='{$session->ipaddress}' or lastip='{$session->ipaddress}' or longregip='".my_ip2long($session->ipaddress)."' or longlastip='".my_ip2long($session->ipaddress)."'");
		while($users = $db->fetch_array($query))
		{
			$names[] = "[url={$mybb->settings['bburl']}/member.php?action=profile&uid={$users['uid']}][b]{$users['username']}[/b][/url]";
		}
		send_mp_a2detector($names,$counts_ips);
	}
}

function send_mp_a2detector($users,$numsip)
{
	global $session,$mybb;
	require_once MYBB_ROOT."inc/datahandlers/pm.php";
	$pmhandler = new PMDataHandler();
	$usernames = implode(",", $users);
	$message = $mybb->settings['aedetector_body'];
	$message = str_replace('{bbname}', $mybb->settings['bbname'], $message);
	$message = str_replace('{names}', $usernames, $message);
	$message = str_replace('{numip}', $numsip, $message);
	$message = str_replace('{ip}', $session->ipaddress, $message);
	$toidsexplode = explode(",",$mybb->settings['aedetector_recipient']);
	$pm = array(
		"subject" => $mybb->settings['aedetector_subject'],
		"message" => $message,
		"icon" => -1,
		"fromid" => intval($mybb->settings['aedetector_sender']),
		"toid" => array_map("intval",$toidsexplode),
		"do" => '',
		"pmid" => ''
	);	
	$pm['options'] = array(
		"signature" => 1,
		"disablesmilies" => 0,
		"savecopy" => 0,
		"readreceipt" => 0
	);
	$pm['saveasdraft'] = 0;
	$pmhandler->admin_override = 1;
	$pmhandler->set_data($pm);
	if($pmhandler->validate_pm())
	{
		$pmhandler->insert_pm();
	}
	else
	{
		a2detector_handle_error($pmhandler);
	}
}

function a2detector_handle_error(&$pmhandler)
{
	global $cache;
	$errors = $cache->read("rss2post_errors");	
	if($errors === false)
	{
		$errors = '';
	}					
	
	$errors .= 'Date: ' . gmdate('r') . "\n";
	
	$datahandler_errors = $pmhandler->get_errors();
	ob_start();
	print_r($datahandler_errors);
	$errors .= ob_get_clean();
	$errors .= "\n\n===========================================\n\n";
	
	$cache->update('a2detector_errors', $errors);
}